# 🚀 cPanel Deployment Guide

This guide describes how to deploy your Laravel application to a cPanel shared hosting environment without terminal/SSH access using the built-in custom installer.

## 📦 Preparation

1.  **Use Pre-packaged ZIP**: I have already created a production-ready package for you named `deploy_ready.zip` in your project root.
    -   *Included*: All production dependencies (`vendor`), compiled assets, and the installer.
2.  **Upload to cPanel**: Use the cPanel "File Manager" to upload `deploy_ready.zip` to your domain's root directory.
3.  **Extract**: Extract the ZIP file.
4.  **Database**: Create a new MySQL Database, User, and Password via cPanel.

## 🛠️ Installation

1.  **Run Installer**: Visit your domain followed by `/install.php` (e.g., `https://yourdomain.com/install.php`).
2.  **Step 1: Welcome**: Click "Start Installation".
3.  **Step 2: Verification**: The script will check if your server meets the requirements. If any folder permissions are missing, fix them in cPanel File Manager and click "Retry".
4.  **Step 3: Database**: Enter the MySQL credentials you created earlier. Click "Test Connection" to verify.
5.  **Step 4: Account**: Fill in your desired Admin details and click "Install Now".
6.  **Progress**: Wait for the installer to generate the `.env` file, run migrations, and seed the database.
7.  **Finished**: You will see a success message!

## 🔒 Post-Installation (CRITICAL)

For security purposes, immediately perform these steps after a successful install:

1.  **Delete Files**: Delete the `install/` folder and the `public/install.php` file from your server.
2.  **Verify .env**: Ensure your `.env` file is present in the root directory and has `APP_DEBUG=false`.

## 🖼️ Troubleshooting

-   **Images Not Showing**: This is common if `symlink()` is disabled.
    -   *Fix*: In cPanel File Manager, go to `public/`, delete the `storage` shortcut (if it exists), and create a manual link or copy the contents of `storage/app/public` to `public/storage`.
-   **404 on Routes**: Ensure the `.htaccess` file is present in your `public/` folder.
-   **Root Deployment**: If your domain doesn't point to the `/public` folder, you may need a root-level `.htaccess` to redirect traffic.

---
*Created by Antigravity Deployment Engine*
