<?php

namespace App\Filament\Pages;

use Filament\Pages\Dashboard as BaseDashboard;
use App\Filament\Widgets\WelcomeHeader;
use App\Filament\Widgets\StatsOverviewCustom;
use App\Filament\Widgets\RevenueChart;
use App\Filament\Widgets\RecentOrdersTable;

class Dashboard extends BaseDashboard
{
    protected static ?string $navigationIcon = 'heroicon-o-home';

    protected static ?string $navigationLabel = 'Dashboard';

    protected static ?string $title = 'Dashboard';

    protected function getWidgets(): array
    {
        return [
            WelcomeHeader::class ,
            StatsOverviewCustom::class ,
            RevenueChart::class ,
            RecentOrdersTable::class ,
        ];
    }

    protected function getColumns(): int|array
    {
        return 2;
    }
}
