<?php

namespace App\Filament\Pages;

use App\Models\Setting;
use Filament\Forms;
use Filament\Pages\Page;
use Filament\Notifications\Notification;

class ManageAnnouncement extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-speakerphone';

    protected static ?string $navigationGroup = 'Content Management';

    protected static ?string $navigationLabel = 'Announcement Bar';

    protected static string $view = 'filament.pages.manage-announcement';

    public $data = [];

    public function mount()
    {
        $this->form->fill([
            'announcement_text' => Setting::get('announcement_text', 'Free shipping on orders over $100 — Use code TWELVE26 for 15% off'),
            'announcement_is_visible' => (bool)Setting::get('announcement_is_visible', true),
            'announcement_bg_color' => Setting::get('announcement_bg_color', '#0f172a'),
            'announcement_text_color' => Setting::get('announcement_text_color', '#ffffff'),
            'announcement_link' => Setting::get('announcement_link', '/products'),
        ]);
    }

    protected function getFormSchema(): array
    {
        return [
            Forms\Components\Card::make()
            ->schema([
                Forms\Components\Toggle::make('announcement_is_visible')
                ->label('Show Announcement Bar'),
                Forms\Components\Textarea::make('announcement_text')
                ->label('Announcement Text')
                ->required()
                ->rows(2),
                Forms\Components\Grid::make(2)
                ->schema([
                    Forms\Components\ColorPicker::make('announcement_bg_color')
                    ->label('Background Color')
                    ->default('#0f172a'),
                    Forms\Components\ColorPicker::make('announcement_text_color')
                    ->label('Text Color')
                    ->default('#ffffff'),
                ]),
                Forms\Components\TextInput::make('announcement_link')
                ->label('Announcement Link (Optional)')
                ->url()
                ->placeholder('https://example.com/collection'),
            ])
        ];
    }

    protected function getFormStatePath(): string
    {
        return 'data';
    }

    public function submit()
    {
        $data = $this->form->getState();

        foreach ($data as $key => $value) {
            Setting::set($key, $value, 'announcement');
        }

        Notification::make()
            ->title('Announcement settings saved!')
            ->success()
            ->send();
    }
}
