<?php

namespace App\Filament\Pages;

use Filament\Forms;
use Filament\Pages\Page;

class SiteSettings extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-cog';

    protected static ?string $navigationGroup = 'Admin & Settings';

    protected static ?int $navigationSort = 2;

    protected static string $view = 'filament.pages.site-settings';

    public $logo;
    public $site_name;
    public $contact_email;
    public $contact_phone;
    public $facebook_url;
    public $twitter_url;
    public $instagram_url;
    public $payment_gateway_stripe;
    public $payment_gateway_paypal;

    public function mount()
    {
        // Load existing settings or defaults
        // In a real app, delete these from a database or config
        $this->form->fill([
            'site_name' => config('app.name'),
            'contact_email' => 'admin@example.com',
            'payment_gateway_stripe' => true,
        ]);
    }

    protected function getFormSchema(): array
    {
        return [
            Forms\Components\Section::make('General Settings')
            ->schema([
                Forms\Components\FileUpload::make('logo')
                ->image()
                ->directory('settings')
                ->label('Site Logo'),
                Forms\Components\TextInput::make('site_name')
                ->required(),
                Forms\Components\TextInput::make('contact_email')
                ->email(),
                Forms\Components\TextInput::make('contact_phone')
                ->tel(),
            ])->columns(2),

            Forms\Components\Section::make('Social Links')
            ->schema([
                Forms\Components\TextInput::make('facebook_url')
                ->url()
                ->label('Facebook URL'),
                Forms\Components\TextInput::make('twitter_url')
                ->url()
                ->label('Twitter URL'),
                Forms\Components\TextInput::make('instagram_url')
                ->url()
                ->label('Instagram URL'),
            ])->columns(3),

            Forms\Components\Section::make('Payment Gateways')
            ->schema([
                Forms\Components\Toggle::make('payment_gateway_stripe')
                ->label('Enable Stripe'),
                Forms\Components\Toggle::make('payment_gateway_paypal')
                ->label('Enable PayPal'),
                Forms\Components\Textarea::make('payment_instructions')
                ->rows(3)
                ->label('Bank Transfer Instructions')
                ->columnSpanFull(),
            ])->columns(2),
        ];
    }

    public function submit()
    {
        $data = $this->form->getState();

        foreach ($data as $key => $value) {
            \App\Models\Setting::set($key, $value);
        }

        $this->notify('success', 'Settings saved successfully!');
    }
}
