<?php

namespace App\Filament\Resources;

use App\Filament\Resources\AccountResource\Pages;
use App\Models\Account;
use Filament\Forms;
use Filament\Resources\Form;
use Filament\Resources\Resource;
use Filament\Resources\Table;
use Filament\Tables;

class AccountResource extends Resource
{
    protected static ?string $model = Account::class;
    protected static ?string $recordTitleAttribute = 'name';
    protected static ?string $navigationGroup = 'Finance';
    protected static ?string $navigationLabel = 'Accounts';
    protected static ?int $navigationSort = 2;
    protected static ?string $navigationIcon = 'heroicon-o-credit-card';

    protected static bool $shouldRegisterNavigation = false;

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Card::make()->schema([
                Forms\Components\TextInput::make('name')
                ->required()
                ->maxLength(255)
                ->placeholder('e.g. Main Bank Account'),
                Forms\Components\Select::make('type')
                ->options([
                    'asset' => 'Asset',
                    'liability' => 'Liability',
                    'equity' => 'Equity',
                    'income' => 'Income',
                    'expense' => 'Expense',
                ])
                ->required(),
                Forms\Components\TextInput::make('balance')
                ->numeric()
                ->prefix('$')
                ->default(0),
                Forms\Components\Textarea::make('description')
                ->rows(2)
                ->columnSpanFull(),
            ])->columns(2),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('name')
            ->searchable()
            ->sortable()
            ->weight('bold'),
            Tables\Columns\BadgeColumn::make('type')
            ->colors([
                'primary' => 'asset',
                'danger' => 'liability',
                'success' => 'equity',
                'warning' => 'income',
                'secondary' => 'expense',
            ]),
            Tables\Columns\TextColumn::make('balance')
            ->money('usd')
            ->sortable(),
            Tables\Columns\TextColumn::make('description')
            ->limit(40),
            Tables\Columns\TextColumn::make('created_at')
            ->dateTime('M d, Y')
            ->sortable(),
        ])->defaultSort('name')
            ->filters([
            Tables\Filters\SelectFilter::make('type')
            ->options([
                'asset' => 'Asset',
                'liability' => 'Liability',
                'equity' => 'Equity',
                'income' => 'Income',
                'expense' => 'Expense',
            ]),
        ])
            ->actions([
            Tables\Actions\EditAction::make(),
            Tables\Actions\DeleteAction::make(),
        ])
            ->bulkActions([Tables\Actions\DeleteBulkAction::make()]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAccounts::route('/'),
            'create' => Pages\CreateAccount::route('/create'),
            'edit' => Pages\EditAccount::route('/{record}/edit'),
        ];
    }
}
