<?php

namespace App\Filament\Resources;

use App\Filament\Resources\AttributeResource\Pages;
use App\Models\Attribute;
use Filament\Forms;
use Filament\Resources\Form;
use Filament\Resources\Resource;
use Filament\Resources\Table;
use Filament\Tables;

class AttributeResource extends Resource
{
    protected static ?string $model = Attribute::class;
    protected static ?string $recordTitleAttribute = 'name';
    protected static ?string $navigationGroup = 'Shop Management';
    protected static ?string $navigationLabel = 'Attributes';
    protected static ?int $navigationSort = 4;
    protected static ?string $navigationIcon = 'heroicon-o-adjustments';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Card::make()->schema([
                Forms\Components\TextInput::make('name')->required()->maxLength(255),
                Forms\Components\Select::make('type')->options(['text' => 'Text', 'color' => 'Color Swatch', 'select' => 'Dropdown', 'radio' => 'Radio Buttons'])->default('text')->required(),
            ])->columns(2),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('name')->searchable()->sortable(),
            Tables\Columns\BadgeColumn::make('type')->colors(['primary' => 'text', 'success' => 'color', 'warning' => 'select', 'secondary' => 'radio']),
            Tables\Columns\TextColumn::make('created_at')->dateTime('M d, Y')->sortable(),
        ])->actions([Tables\Actions\EditAction::make(), Tables\Actions\DeleteAction::make()])->bulkActions([Tables\Actions\DeleteBulkAction::make()]);
    }

    public static function getPages(): array
    {
        return ['index' => Pages\ListAttributes::route('/'), 'create' => Pages\CreateAttribute::route('/create'), 'edit' => Pages\EditAttribute::route('/{record}/edit')];
    }
}
