<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ContentPageResource\Pages;
use App\Models\ContentPage;
use Filament\Forms;
use Filament\Resources\Form;
use Filament\Resources\Resource;
use Filament\Resources\Table;
use Filament\Tables;
use Illuminate\Support\Str;

class ContentPageResource extends Resource
{
    protected static ?string $model = ContentPage::class;
    protected static ?string $recordTitleAttribute = 'title';
    protected static ?string $navigationGroup = 'Content Management';
    protected static ?string $navigationLabel = 'Pages';
    protected static ?int $navigationSort = 2;
    protected static ?string $navigationIcon = 'heroicon-o-document';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Card::make()->schema([
                Forms\Components\TextInput::make('title')->required()->maxLength(255)
                    ->reactive()->afterStateUpdated(fn ($state, callable $set) => $set('slug', Str::slug($state))),
                Forms\Components\TextInput::make('slug')->required()->disabled()->dehydrated()
                    ->unique(ContentPage::class, 'slug', ignoreRecord: true),
                Forms\Components\RichEditor::make('content')->required()->columnSpanFull(),
                Forms\Components\TextInput::make('meta_title')->maxLength(255),
                Forms\Components\Textarea::make('meta_description')->rows(2),
                Forms\Components\Toggle::make('is_active')->label('Published')->default(true),
            ])->columns(2),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('title')->searchable()->sortable(),
            Tables\Columns\TextColumn::make('slug')->searchable(),
            Tables\Columns\BooleanColumn::make('is_active')->label('Published'),
            Tables\Columns\TextColumn::make('updated_at')->dateTime('M d, Y')->sortable(),
        ])->actions([Tables\Actions\EditAction::make(),Tables\Actions\DeleteAction::make()])->bulkActions([Tables\Actions\DeleteBulkAction::make()]);
    }

    public static function getPages(): array
    {
        return ['index'=>Pages\ListContentPages::route('/'),'create'=>Pages\CreateContentPage::route('/create'),'edit'=>Pages\EditContentPage::route('/{record}/edit')];
    }
}
