<?php

namespace App\Filament\Resources\CustomerResource\RelationManagers;

use Filament\Forms;
use Filament\Resources\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Resources\Table;
use Filament\Tables;

class OrdersRelationManager extends RelationManager
{
    protected static string $relationship = 'orders';

    protected static ?string $recordTitleAttribute = 'number';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
            Forms\Components\TextInput::make('number')
            ->required()
            ->maxLength(255),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
            Tables\Columns\TextColumn::make('number')->searchable(),
            Tables\Columns\BadgeColumn::make('status')
            ->colors([
                'warning' => 'pending',
                'success' => 'completed',
                'danger' => 'cancelled',
            ]),
            Tables\Columns\TextColumn::make('total_price')->money('usd'),
            Tables\Columns\TextColumn::make('created_at')->dateTime('M d, Y'),
        ])
            ->filters([
            //
        ])
            ->headerActions([
            //
        ])
            ->actions([
            Tables\Actions\ViewAction::make(),
        ])
            ->bulkActions([
            //
        ]);
    }
}
