<?php

namespace App\Filament\Resources;

use App\Filament\Resources\FlashSaleResource\Pages;
use App\Models\FlashSale;
use Filament\Forms;
use Filament\Resources\Form;
use Filament\Resources\Resource;
use Filament\Resources\Table;
use Filament\Tables;

class FlashSaleResource extends Resource
{
    protected static ?string $model = FlashSale::class;
    protected static ?string $recordTitleAttribute = 'title';
    protected static ?string $navigationGroup = 'Marketing';
    protected static ?string $navigationLabel = 'Flash Sales';
    protected static ?int $navigationSort = 2;
    protected static ?string $navigationIcon = 'heroicon-o-lightning-bolt';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Card::make()->schema([
                Forms\Components\TextInput::make('title')
                ->required()
                ->maxLength(255),
                Forms\Components\Textarea::make('description')
                ->rows(2)
                ->columnSpanFull(),
                Forms\Components\Grid::make(2)->schema([
                    Forms\Components\DateTimePicker::make('starts_at')
                    ->required()
                    ->label('Start Time'),
                    Forms\Components\DateTimePicker::make('ends_at')
                    ->required()
                    ->label('End Time')
                    ->after('starts_at'),
                ]),
                Forms\Components\Toggle::make('is_active')
                ->default(true)
                ->label('Active'),
            ]),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('title')
            ->searchable()
            ->sortable(),
            Tables\Columns\TextColumn::make('starts_at')
            ->dateTime('M d, Y H:i')
            ->sortable(),
            Tables\Columns\TextColumn::make('ends_at')
            ->dateTime('M d, Y H:i')
            ->sortable(),
            Tables\Columns\BadgeColumn::make('status')
            ->getStateUsing(function ($record) {
            if (!$record->is_active)
                return 'inactive';
            if ($record->ends_at->isPast())
                return 'ended';
            if ($record->starts_at->isFuture())
                return 'upcoming';
            return 'running';
        })
            ->colors([
                'success' => 'running',
                'warning' => 'upcoming',
                'danger' => 'ended',
                'secondary' => 'inactive',
            ]),
            Tables\Columns\TextColumn::make('products_count')
            ->counts('products')
            ->label('Products'),
            Tables\Columns\BooleanColumn::make('is_active')
            ->label('Active'),
        ])->defaultSort('starts_at', 'desc')
            ->actions([
            Tables\Actions\EditAction::make(),
            Tables\Actions\DeleteAction::make(),
        ])
            ->bulkActions([Tables\Actions\DeleteBulkAction::make()]);
    }

    public static function getRelations(): array
    {
        return [];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListFlashSales::route('/'),
            'create' => Pages\CreateFlashSale::route('/create'),
            'edit' => Pages\EditFlashSale::route('/{record}/edit'),
        ];
    }
}
