<?php

namespace App\Filament\Resources\MediaFileResource\Pages;

use App\Filament\Resources\MediaFileResource;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\Storage;

class CreateMediaFile extends CreateRecord
{
    protected static string $resource = MediaFileResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        if (!empty($data['file_path'])) {
            $path = $data['file_path'];

            // Calculate size
            $data['file_size'] = Storage::disk('public')->exists($path)
                ?Storage::disk('public')->size($path)
                : 0;

            // Detect Type
            $mime = Storage::disk('public')->mimeType($path);
            if (str_contains($mime, 'image')) {
                $data['file_type'] = 'image';
            }
            elseif (str_contains($mime, 'video')) {
                $data['file_type'] = 'video';
            }
            elseif (str_contains($mime, 'audio')) {
                $data['file_type'] = 'audio';
            }
            else {
                $data['file_type'] = 'document';
            }
        }
        else {
            $data['file_size'] = 0;
            $data['file_type'] = 'document'; // Fallback
        }

        return $data;
    }
}
