<?php

namespace App\Filament\Resources\MediaFileResource\Pages;

use App\Filament\Resources\MediaFileResource;
use Filament\Pages\Actions;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Support\Facades\Storage;

class EditMediaFile extends EditRecord
{
    protected static string $resource = MediaFileResource::class;

    protected function getActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        if (!empty($data['file_path'])) {
            $path = $data['file_path'];

            // Update size if file changed/exists
            if (Storage::disk('public')->exists($path)) {
                $data['file_size'] = Storage::disk('public')->size($path);

                // Update Type
                $mime = Storage::disk('public')->mimeType($path);
                if (str_contains($mime, 'image')) {
                    $data['file_type'] = 'image';
                }
                elseif (str_contains($mime, 'video')) {
                    $data['file_type'] = 'video';
                }
                elseif (str_contains($mime, 'audio')) {
                    $data['file_type'] = 'audio';
                }
                else {
                    $data['file_type'] = 'document';
                }
            }
        }

        return $data;
    }
}
