<?php

namespace App\Filament\Resources;

use App\Filament\Resources\NewsletterSubscriberResource\Pages;
use App\Models\NewsletterSubscriber;
use Filament\Forms;
use Filament\Resources\Form;
use Filament\Resources\Resource;
use Filament\Resources\Table;
use Filament\Tables;

class NewsletterSubscriberResource extends Resource
{
    protected static ?string $model = NewsletterSubscriber::class;

    protected static ?string $navigationGroup = 'Marketing';

    protected static ?string $navigationLabel = 'Newsletter Subscribers';

    protected static ?int $navigationSort = 3;

    protected static ?string $navigationIcon = 'heroicon-o-mail';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
            Forms\Components\Card::make()
            ->schema([
                Forms\Components\TextInput::make('email')
                ->email()
                ->required()
                ->maxLength(255),
                Forms\Components\TextInput::make('name')
                ->maxLength(255),
                Forms\Components\Toggle::make('is_active')
                ->label('Subscribed')
                ->default(true),
                Forms\Components\DateTimePicker::make('subscribed_at')
                ->default(now()),
                Forms\Components\DateTimePicker::make('unsubscribed_at'),
            ])->columns(2),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
            Tables\Columns\TextColumn::make('email')
            ->searchable()
            ->sortable(),
            Tables\Columns\TextColumn::make('name')
            ->searchable(),
            Tables\Columns\BooleanColumn::make('is_active')
            ->label('Subscribed'),
            Tables\Columns\TextColumn::make('subscribed_at')
            ->dateTime('M d, Y H:i')
            ->sortable(),
            Tables\Columns\TextColumn::make('created_at')
            ->dateTime('M d, Y')
            ->sortable(),
        ])
            ->filters([
            Tables\Filters\TernaryFilter::make('is_active')
            ->label('Subscription Status')
            ->trueLabel('Subscribed')
            ->falseLabel('Unsubscribed'),
        ])
            ->actions([
            Tables\Actions\EditAction::make(),
            Tables\Actions\DeleteAction::make(),
        ])
            ->bulkActions([
            Tables\Actions\DeleteBulkAction::make(),
        ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListNewsletterSubscribers::route('/'),
            'create' => Pages\CreateNewsletterSubscriber::route('/create'),
            'edit' => Pages\EditNewsletterSubscriber::route('/{record}/edit'),
        ];
    }
}
