<?php

namespace App\Filament\Resources\ProductResource\RelationManagers;

use Filament\Forms;
use Filament\Resources\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Resources\Table;
use Filament\Tables;

class AttributesRelationManager extends RelationManager
{
    protected static string $relationship = 'attributes';

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
            Forms\Components\TextInput::make('value')
            ->required()
            ->maxLength(255),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
            Tables\Columns\TextColumn::make('name'),
            Tables\Columns\BadgeColumn::make('type')
            ->colors(['primary', 'secondary' => 'color', 'warning' => 'select']),
            Tables\Columns\TextColumn::make('value')
            ->label('Value')
            ->searchable(),
        ])
            ->headerActions([
            Tables\Actions\AttachAction::make()
            ->preloadRecordSelect()
            ->form(fn(Tables\Actions\AttachAction $action): array => [
        $action->getRecordSelect(),
        Forms\Components\TextInput::make('value')
        ->required()
        ->maxLength(255),
        ]),
        ])
            ->actions([
            Tables\Actions\DetachAction::make(),
            Tables\Actions\EditAction::make(),
        ])
            ->bulkActions([
            Tables\Actions\DetachBulkAction::make(),
        ]);
    }
}
