<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ProductVariationResource\Pages;
use App\Models\ProductVariation;
use Filament\Forms;
use Filament\Resources\Form;
use Filament\Resources\Resource;
use Filament\Resources\Table;
use Filament\Tables;

class ProductVariationResource extends Resource
{
    protected static ?string $model = ProductVariation::class;
    protected static ?string $recordTitleAttribute = 'value';
    protected static ?string $navigationGroup = 'Shop Management';
    protected static ?string $navigationLabel = 'Variations';
    protected static ?int $navigationSort = 4;
    protected static ?string $navigationIcon = 'heroicon-o-switch-horizontal';

    protected static bool $shouldRegisterNavigation = false;

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Card::make()->schema([
                Forms\Components\Select::make('product_id')->relationship('product', 'name')->required()->searchable()->preload(),
                Forms\Components\Select::make('attribute_id')->relationship('attribute', 'name')->required()->searchable()->preload(),
                Forms\Components\TextInput::make('value')->required()->maxLength(255),
                Forms\Components\TextInput::make('sku')->label('SKU')->maxLength(50),
                Forms\Components\TextInput::make('price_adjustment')->numeric()->default(0)->prefix('$'),
                Forms\Components\TextInput::make('stock')->numeric()->default(0)->minValue(0),
                Forms\Components\Toggle::make('is_active')->label('Active')->default(true),
            ])->columns(2),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('product.name')->label('Product')->searchable()->sortable()->limit(25),
            Tables\Columns\TextColumn::make('attribute.name')->label('Attribute'),
            Tables\Columns\TextColumn::make('value')->searchable(),
            Tables\Columns\TextColumn::make('sku')->label('SKU')->searchable(),
            Tables\Columns\TextColumn::make('price_adjustment')->money('usd')->label('Price +/-'),
            Tables\Columns\TextColumn::make('stock')->sortable(),
            Tables\Columns\BooleanColumn::make('is_active')->label('Active'),
        ])->defaultSort('product_id')
            ->filters([
            Tables\Filters\SelectFilter::make('product')->relationship('product', 'name'),
            Tables\Filters\SelectFilter::make('attribute')->relationship('attribute', 'name'),
        ])->actions([Tables\Actions\EditAction::make(), Tables\Actions\DeleteAction::make()])->bulkActions([Tables\Actions\DeleteBulkAction::make()]);
    }

    public static function getPages(): array
    {
        return ['index' => Pages\ListProductVariations::route('/'), 'create' => Pages\CreateProductVariation::route('/create'), 'edit' => Pages\EditProductVariation::route('/{record}/edit')];
    }
}
