<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PurchaseResource\Pages;
use App\Models\Purchase;
use Filament\Forms;
use Filament\Resources\Form;
use Filament\Resources\Resource;
use Filament\Resources\Table;
use Filament\Tables;

class PurchaseResource extends Resource
{
    protected static ?string $model = Purchase::class;
    protected static ?string $navigationGroup = 'Inventory';
    protected static ?string $navigationLabel = 'Purchases';
    protected static ?int $navigationSort = 2;
    protected static ?string $navigationIcon = 'heroicon-o-receipt-tax';

    protected static bool $shouldRegisterNavigation = false;

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Card::make()->schema([
                Forms\Components\Select::make('vendor_id')
                ->relationship('vendor', 'name')
                ->required()
                ->searchable()
                ->preload()
                ->label('Supplier'),
                Forms\Components\Select::make('status')
                ->options([
                    'pending' => 'Pending',
                    'received' => 'Received',
                    'cancelled' => 'Cancelled',
                ])
                ->default('pending')
                ->required(),
                Forms\Components\TextInput::make('total_amount')
                ->numeric()
                ->prefix('$')
                ->required(),
                Forms\Components\DatePicker::make('purchase_date')
                ->default(now())
                ->required()
                ->label('Purchase Date'),
                Forms\Components\Textarea::make('notes')
                ->rows(2)
                ->columnSpanFull(),
            ])->columns(2),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('id')
            ->label('PO #')
            ->sortable(),
            Tables\Columns\TextColumn::make('vendor.name')
            ->label('Supplier')
            ->searchable(),
            Tables\Columns\TextColumn::make('total_amount')
            ->money('usd')
            ->sortable(),
            Tables\Columns\BadgeColumn::make('status')
            ->colors([
                'warning' => 'pending',
                'success' => 'received',
                'danger' => 'cancelled',
            ]),
            Tables\Columns\TextColumn::make('purchase_date')
            ->date('M d, Y')
            ->sortable()
            ->label('Purchase Date'),
            Tables\Columns\TextColumn::make('created_at')
            ->dateTime('M d, Y')
            ->sortable(),
        ])->defaultSort('created_at', 'desc')
            ->filters([
            Tables\Filters\SelectFilter::make('status')
            ->options([
                'pending' => 'Pending',
                'received' => 'Received',
                'cancelled' => 'Cancelled',
            ]),
        ])
            ->actions([
            Tables\Actions\EditAction::make(),
            Tables\Actions\DeleteAction::make(),
        ])
            ->bulkActions([Tables\Actions\DeleteBulkAction::make()]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPurchases::route('/'),
            'create' => Pages\CreatePurchase::route('/create'),
            'edit' => Pages\EditPurchase::route('/{record}/edit'),
        ];
    }
}
