<?php

namespace App\Filament\Resources\PurchaseResource\Pages;

use App\Filament\Resources\PurchaseResource;
use Filament\Pages\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreatePurchase extends CreateRecord
{
    protected static string $resource = PurchaseResource::class;

    protected function afterCreate(): void
    {
        $purchase = $this->record;

        if ($purchase->product_id && $purchase->quantity) {
            $product = \App\Models\Product::find($purchase->product_id);
            if ($product) {
                $product->increment('stock', $purchase->quantity);
            }
        }
    }
}
