<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ShippingMethodResource\Pages;
use App\Models\ShippingMethod;
use Filament\Forms;
use Filament\Resources\Form;
use Filament\Resources\Resource;
use Filament\Resources\Table;
use Filament\Tables;

class ShippingMethodResource extends Resource
{
    protected static ?string $model = ShippingMethod::class;
    protected static ?string $recordTitleAttribute = 'name';
    protected static ?string $navigationGroup = 'Inventory & Logistics';
    protected static ?string $navigationLabel = 'Shipping Methods';
    protected static ?int $navigationSort = 2;
    protected static ?string $navigationIcon = 'heroicon-o-truck';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Card::make()->schema([
                Forms\Components\Grid::make(2)->schema([
                    Forms\Components\TextInput::make('name')
                    ->required()
                    ->maxLength(255),
                    Forms\Components\Select::make('type')
                    ->options([
                        'flat_rate' => 'Flat Rate',
                        'free' => 'Free Shipping',
                        'weight_based' => 'Weight Based',
                        'price_based' => 'Price Based',
                    ])
                    ->default('flat_rate')
                    ->required(),
                    Forms\Components\TextInput::make('cost')
                    ->numeric()
                    ->prefix('$')
                    ->default(0),
                    Forms\Components\TextInput::make('min_order_amount')
                    ->numeric()
                    ->prefix('$')
                    ->label('Min Order for Free Shipping'),
                ]),
                Forms\Components\Textarea::make('description')
                ->rows(2)
                ->columnSpanFull(),
                Forms\Components\Grid::make(2)->schema([
                    Forms\Components\TextInput::make('sort_order')
                    ->numeric()
                    ->default(0),
                    Forms\Components\Toggle::make('is_active')
                    ->default(true)
                    ->label('Active'),
                ]),
            ]),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('name')
            ->searchable()
            ->sortable(),
            Tables\Columns\BadgeColumn::make('type')
            ->colors([
                'primary' => 'flat_rate',
                'success' => 'free',
                'warning' => 'weight_based',
                'info' => 'price_based',
            ]),
            Tables\Columns\TextColumn::make('cost')
            ->money('usd')
            ->sortable(),
            Tables\Columns\TextColumn::make('sort_order')
            ->sortable(),
            Tables\Columns\BooleanColumn::make('is_active')
            ->label('Active'),
        ])->defaultSort('sort_order')
            ->reorderable('sort_order')
            ->actions([
            Tables\Actions\EditAction::make(),
            Tables\Actions\DeleteAction::make(),
        ])
            ->bulkActions([Tables\Actions\DeleteBulkAction::make()]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListShippingMethods::route('/'),
            'create' => Pages\CreateShippingMethod::route('/create'),
            'edit' => Pages\EditShippingMethod::route('/{record}/edit'),
        ];
    }
}
