<?php

namespace App\Filament\Resources;

use App\Filament\Resources\StockMovementResource\Pages;
use App\Models\StockMovement;
use Filament\Forms;
use Filament\Resources\Form;
use Filament\Resources\Resource;
use Filament\Resources\Table;
use Filament\Tables;

class StockMovementResource extends Resource
{
    protected static ?string $model = StockMovement::class;
    protected static ?string $navigationGroup = 'Inventory & Logistics';
    protected static ?string $navigationLabel = 'Stock Movements';
    protected static ?int $navigationSort = 1;
    protected static ?string $navigationIcon = 'heroicon-o-arrows-expand';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Card::make()->schema([
                Forms\Components\Select::make('product_id')
                ->relationship('product', 'name')
                ->required()
                ->searchable()
                ->preload(),
                Forms\Components\Select::make('type')
                ->options([
                    'in' => 'Stock In',
                    'out' => 'Stock Out',
                    'adjustment' => 'Adjustment',
                ])
                ->required()
                ->default('in'),
                Forms\Components\TextInput::make('quantity')
                ->numeric()
                ->required()
                ->minValue(1),
                Forms\Components\Textarea::make('reason')
                ->rows(2),
                Forms\Components\Textarea::make('notes')
                ->rows(2)
                ->label('Notes'),
            ])->columns(2),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('product.name')
            ->label('Product')
            ->searchable()
            ->sortable()
            ->limit(25),
            Tables\Columns\BadgeColumn::make('type')
            ->colors([
                'success' => 'in',
                'danger' => 'out',
                'warning' => 'adjustment',
            ]),
            Tables\Columns\TextColumn::make('quantity')
            ->sortable(),
            Tables\Columns\TextColumn::make('reason')
            ->limit(30),
            Tables\Columns\TextColumn::make('notes')
            ->label('Notes')
            ->limit(30),
            Tables\Columns\TextColumn::make('created_at')
            ->dateTime('M d, Y H:i')
            ->sortable(),
        ])->defaultSort('created_at', 'desc')
            ->filters([
            Tables\Filters\SelectFilter::make('type')
            ->options([
                'in' => 'Stock In',
                'out' => 'Stock Out',
                'adjustment' => 'Adjustment',
            ]),
        ])
            ->actions([
            Tables\Actions\EditAction::make(),
            Tables\Actions\DeleteAction::make(),
        ])
            ->bulkActions([Tables\Actions\DeleteBulkAction::make()]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListStockMovements::route('/'),
            'create' => Pages\CreateStockMovement::route('/create'),
            'edit' => Pages\EditStockMovement::route('/{record}/edit'),
        ];
    }
}
