<?php

namespace App\Filament\Resources;

use App\Filament\Resources\TaxRateResource\Pages;
use App\Models\TaxRate;
use Filament\Forms;
use Filament\Resources\Form;
use Filament\Resources\Resource;
use Filament\Resources\Table;
use Filament\Tables;

class TaxRateResource extends Resource
{
    protected static ?string $model = TaxRate::class;
    protected static ?string $recordTitleAttribute = 'name';
    protected static ?string $navigationGroup = 'Inventory & Logistics';
    protected static ?string $navigationLabel = 'Tax Rates';
    protected static ?int $navigationSort = 3;
    protected static ?string $navigationIcon = 'heroicon-o-receipt-tax';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Card::make()->schema([
                Forms\Components\Grid::make(2)->schema([
                    Forms\Components\TextInput::make('name')
                    ->required()
                    ->maxLength(255)
                    ->placeholder('e.g. GST, VAT, Sales Tax'),
                    Forms\Components\TextInput::make('rate')
                    ->numeric()
                    ->required()
                    ->suffix('%'),
                    Forms\Components\Select::make('type')
                    ->options([
                        'percentage' => 'Percentage',
                        'fixed' => 'Fixed Amount',
                    ])
                    ->default('percentage')
                    ->required(),
                    Forms\Components\TextInput::make('country')
                    ->maxLength(255),
                    Forms\Components\TextInput::make('state')
                    ->maxLength(255),
                    Forms\Components\TextInput::make('priority')
                    ->numeric()
                    ->default(0),
                ]),
                Forms\Components\Toggle::make('is_active')
                ->default(true)
                ->label('Active'),
            ]),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table->columns([
            Tables\Columns\TextColumn::make('name')
            ->searchable()
            ->sortable(),
            Tables\Columns\TextColumn::make('rate')
            ->suffix('%')
            ->sortable(),
            Tables\Columns\BadgeColumn::make('type')
            ->colors(['primary' => 'percentage', 'success' => 'fixed']),
            Tables\Columns\TextColumn::make('country')
            ->searchable(),
            Tables\Columns\TextColumn::make('state')
            ->searchable(),
            Tables\Columns\BooleanColumn::make('is_active')
            ->label('Active'),
        ])->defaultSort('priority')
            ->actions([
            Tables\Actions\EditAction::make(),
            Tables\Actions\DeleteAction::make(),
        ])
            ->bulkActions([Tables\Actions\DeleteBulkAction::make()]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListTaxRates::route('/'),
            'create' => Pages\CreateTaxRate::route('/create'),
            'edit' => Pages\EditTaxRate::route('/{record}/edit'),
        ];
    }
}
