<?php

namespace App\Filament\Resources;

use App\Filament\Resources\TestimonialResource\Pages;
use App\Models\Testimonial;
use Filament\Forms;
use Filament\Resources\Form;
use Filament\Resources\Resource;
use Filament\Resources\Table;
use Filament\Tables;

class TestimonialResource extends Resource
{
    protected static ?string $model = Testimonial::class;

    protected static ?string $navigationGroup = 'Sales & CRM';

    protected static ?string $navigationLabel = 'Reviews / Ratings';

    protected static ?int $navigationSort = 4;

    protected static ?string $navigationIcon = 'heroicon-o-chat-alt-2';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
            Forms\Components\Card::make()
            ->schema([
                Forms\Components\TextInput::make('name')
                ->required()
                ->maxLength(255)
                ->label('Customer Name'),
                Forms\Components\TextInput::make('designation')
                ->maxLength(255)
                ->label('Designation / Role')
                ->placeholder('e.g. CEO of Company'),
                Forms\Components\Textarea::make('content')
                ->required()
                ->rows(3)
                ->columnSpanFull()
                ->label('Testimonial Content'),
                Forms\Components\Select::make('rating')
                ->options([
                    1 => '⭐ 1 Star',
                    2 => '⭐⭐ 2 Stars',
                    3 => '⭐⭐⭐ 3 Stars',
                    4 => '⭐⭐⭐⭐ 4 Stars',
                    5 => '⭐⭐⭐⭐⭐ 5 Stars',
                ])
                ->default(5)
                ->required(),
                Forms\Components\FileUpload::make('image')
                ->image()
                ->directory('testimonials')
                ->label('Customer Image'),
                Forms\Components\Toggle::make('is_active')
                ->label('Active')
                ->default(true),
            ])->columns(2),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
            Tables\Columns\ImageColumn::make('image')->circular(),
            Tables\Columns\TextColumn::make('name')->searchable()->sortable(),
            Tables\Columns\TextColumn::make('rating')
            ->formatStateUsing(fn($state) => str_repeat('⭐', $state))
            ->sortable(),
            Tables\Columns\BooleanColumn::make('is_active')->label('Active'),
            Tables\Columns\TextColumn::make('created_at')->dateTime('M d, Y')->sortable(),
        ])
            ->filters([
            //
        ])
            ->actions([
            Tables\Actions\EditAction::make(),
            Tables\Actions\DeleteAction::make(),
        ])
            ->bulkActions([
            Tables\Actions\DeleteBulkAction::make(),
        ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListTestimonials::route('/'),
            'create' => Pages\CreateTestimonial::route('/create'),
            'edit' => Pages\EditTestimonial::route('/{record}/edit'),
        ];
    }
}
