<?php

namespace App\Filament\Widgets;

use Closure;
use Filament\Tables;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Database\Eloquent\Builder;

class LatestOrders extends BaseWidget
{
    protected static ?int $sort = 2;
    protected static ?string $heading = 'Recent Orders';
    protected int|string|array $columnSpan = 'full';

    protected function getTableQuery(): Builder
    {
        return \App\Models\Order::query()->latest()->limit(10);
    }

    protected function getTableColumns(): array
    {
        return [
            Tables\Columns\TextColumn::make('number')
            ->label('Order ID')
            ->searchable()
            ->sortable()
            ->weight('bold'),
            Tables\Columns\TextColumn::make('user.name')
            ->label('Customer')
            ->searchable(),
            Tables\Columns\TextColumn::make('created_at')
            ->label('Date')
            ->date('M d, Y')
            ->sortable(),
            Tables\Columns\TextColumn::make('total_price')
            ->label('Amount')
            ->money('usd')
            ->sortable()
            ->color('success'),
            Tables\Columns\BadgeColumn::make('status')
            ->colors([
                'warning' => 'pending',
                'primary' => fn($state): bool => in_array($state, ['confirmed', 'processing']),
                'success' => 'delivered',
                'info' => 'shipped',
                'danger' => fn($state): bool => in_array($state, ['cancelled', 'returned', 'refunded']),
            ]),
            Tables\Columns\BadgeColumn::make('payment_status')
            ->label('Payment')
            ->colors([
                'warning' => 'pending',
                'success' => 'paid',
                'danger' => fn($state): bool => in_array($state, ['failed', 'refunded']),
            ]),
        ];
    }

    protected function getTableActions(): array
    {
        return [
            Tables\Actions\Action::make('view')
            ->label('View')
            ->icon('heroicon-o-eye')
            ->url(fn($record) => route('filament.resources.orders.edit', $record))
            ->color('primary'),
        ];
    }

    protected function isTablePaginationEnabled(): bool
    {
        return false;
    }
}
