<?php

namespace App\Filament\Widgets;

use Closure;
use Filament\Tables;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Database\Eloquent\Builder;

class LowStockAlerts extends BaseWidget
{
    protected static ?int $sort = 4;
    protected static ?string $heading = 'Low Stock Alerts';
    protected int|string|array $columnSpan = 1;

    protected function getTableQuery(): Builder
    {
        return \App\Models\Product::query()
            ->where('stock', '<', 10)
            ->where('is_active', true)
            ->orderBy('stock', 'asc');
    }

    protected function getTableColumns(): array
    {
        return [
            Tables\Columns\TextColumn::make('name')
            ->label('Product')
            ->searchable()
            ->limit(30),
            Tables\Columns\TextColumn::make('stock')
            ->label('Stock')
            ->sortable()
            ->color('danger')
            ->weight('bold'),
            Tables\Columns\TextColumn::make('price')
            ->money('usd')
            ->sortable(),
        ];
    }

    protected function getTableActions(): array
    {
        return [
            Tables\Actions\Action::make('edit')
            ->label('Edit')
            ->icon('heroicon-o-pencil')
            ->url(fn($record) => route('filament.resources.products.edit', $record))
            ->color('primary'),
        ];
    }

    protected function isTablePaginationEnabled(): bool
    {
        return false;
    }
}
