<?php

namespace App\Filament\Widgets;

use App\Models\Order;
use Closure;
use Filament\Tables;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Database\Eloquent\Builder;

class RecentOrdersTable extends BaseWidget
{
    protected static ?int $sort = 3;

    protected int|string|array $columnSpan = 1; // Half width

    protected function getTableQuery(): Builder
    {
        return Order::query()->latest()->limit(5);
    }

    protected function getTableColumns(): array
    {
        return [
            Tables\Columns\TextColumn::make('number')
            ->label('Order ID')
            ->searchable(),
            Tables\Columns\TextColumn::make('user.name')
            ->label('Customer'),
            Tables\Columns\BadgeColumn::make('status')
            ->colors([
                'warning' => 'pending',
                'success' => 'completed',
                'danger' => 'cancelled',
            ]),
            Tables\Columns\TextColumn::make('total_price')
            ->money('usd')
            ->label('Amount'),
        ];
    }
}
