<?php

namespace App\Filament\Widgets;

use App\Models\Order;
use Filament\Widgets\LineChartWidget;
use Illuminate\Support\Facades\DB;

class RevenueChart extends LineChartWidget
{
    protected static ?string $heading = 'Revenue Overview';

    protected static ?int $sort = 2;

    protected int|string|array $columnSpan = 1; // Half width

    protected function getData(): array
    {
        // Get daily revenue for the current year
        $data = Order::select(
            DB::raw('DATE(created_at) as date'),
            DB::raw('SUM(total_price) as total')
        )
            ->whereYear('created_at', date('Y'))
            ->groupBy('date')
            ->orderBy('date')
            ->get();

        return [
            'datasets' => [
                [
                    'label' => 'Revenue',
                    'data' => $data->pluck('total')->toArray(),
                    'borderColor' => '#6C5DD3', // Custom primary color
                    'backgroundColor' => 'rgba(108, 93, 211, 0.1)',
                    'pointBackgroundColor' => '#6C5DD3',
                    'fill' => 'start',
                    'tension' => 0.4,
                ],
            ],
            'labels' => $data->pluck('date')->toArray(),
        ];
    }
}
