<?php

namespace App\Filament\Widgets;

use App\Models\Order;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Card;

class StatsOverview extends BaseWidget
{
    protected function getCards(): array
    {
        // Total Sales (Revenue)
        $revenueCurrentMonth = Order::whereMonth('created_at', now()->month)->sum('total_price');
        $revenueLastMonth = Order::whereMonth('created_at', now()->subMonth()->month)->sum('total_price');
        $revenueTrend = $this->calculateTrend($revenueCurrentMonth, $revenueLastMonth);

        // Total Orders
        $ordersCurrentMonth = Order::whereMonth('created_at', now()->month)->count();
        $ordersLastMonth = Order::whereMonth('created_at', now()->subMonth()->month)->count();
        $ordersTrend = $this->calculateTrend($ordersCurrentMonth, $ordersLastMonth);

        // New Customers
        $customersCurrentMonth = \App\Models\User::whereMonth('created_at', now()->month)->count();
        $customersLastMonth = \App\Models\User::whereMonth('created_at', now()->subMonth()->month)->count();
        $customersTrend = $this->calculateTrend($customersCurrentMonth, $customersLastMonth);

        return [
            Card::make('Total Sales', '$' . number_format($revenueCurrentMonth, 2))
            ->description($revenueTrend['description'])
            ->descriptionIcon($revenueTrend['icon'])
            ->color($revenueTrend['color']),

            Card::make('Total Orders', $ordersCurrentMonth)
            ->description($ordersTrend['description'])
            ->descriptionIcon($ordersTrend['icon'])
            ->color($ordersTrend['color']),

            Card::make('New Customers', $customersCurrentMonth)
            ->description($customersTrend['description'])
            ->descriptionIcon($customersTrend['icon'])
            ->color($customersTrend['color']),
        ];
    }

    protected function calculateTrend($current, $previous): array
    {
        if ($previous == 0) {
            return [
                'description' => 'No prior data',
                'icon' => 'heroicon-s-minus',
                'color' => 'secondary',
            ];
        }

        $percentage = (($current - $previous) / $previous) * 100;
        $increase = $percentage >= 0;

        return [
            'description' => number_format(abs($percentage), 1) . '% ' . ($increase ? 'increase' : 'decrease'),
            'icon' => $increase ? 'heroicon-s-trending-up' : 'heroicon-s-trending-down',
            'color' => $increase ? 'success' : 'danger',
        ];
    }
}
