<?php

namespace App\Filament\Widgets;

use App\Models\Order;
use App\Models\Product;
use App\Models\User;
use Filament\Widgets\Widget;

class StatsOverviewCustom extends Widget
{
    protected static string $view = 'filament.widgets.stats-overview-custom';

    protected int|string|array $columnSpan = 'full';

    public function getViewData(): array
    {
        // Total Income (Revenue)
        $revenueCurrent = Order::whereMonth('created_at', now()->month)->sum('total_price');
        $revenueLast = Order::whereMonth('created_at', now()->subMonth()->month)->sum('total_price');
        $revenueGrowth = $this->calculateGrowth($revenueCurrent, $revenueLast);

        // Total Orders (Spending equivalent)
        $ordersCurrent = Order::whereMonth('created_at', now()->month)->count();
        $ordersLast = Order::whereMonth('created_at', now()->subMonth()->month)->count();
        $ordersGrowth = $this->calculateGrowth($ordersCurrent, $ordersLast);

        // Top Product (Balance equivalent - visual placeholder in reference)
        $topProduct = Product::withCount('orderItems')
            ->orderBy('order_items_count', 'desc')
            ->first();

        return [
            'revenue' => [
                'value' => number_format($revenueCurrent, 2),
                'growth' => $revenueGrowth,
                'label' => 'Total Revenue',
            ],
            'orders' => [
                'value' => number_format($ordersCurrent),
                'growth' => $ordersGrowth,
                'label' => 'Total Orders',
            ],
            'top_product' => $topProduct ? $topProduct->name : 'N/A',
        ];
    }

    protected function calculateGrowth($current, $previous)
    {
        if ($previous == 0)
            return 0;
        return round((($current - $previous) / $previous) * 100, 1);
    }
}
