<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function index()
    {
        $categories = \App\Models\Category::where('is_active', true)
            ->whereNull('parent_id')
            ->with(['children' => function ($q) {
            $q->where('is_active', true)
                ->withCount('products')
                ->with(['children' => function ($q2) {
                $q2->where('is_active', true)->withCount('products');
            }
                ]);
        }])
            ->withCount('products')
            ->get();
        return response()->json($categories);
    }

    public function show($slug)
    {
        $category = \App\Models\Category::where('slug', $slug)
            ->where('is_active', true)
            ->with(['children' => function ($q) {
            $q->where('is_active', true)->withCount('products');
        }])
            ->firstOrFail();
        return response()->json($category);
    }
}
