<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\FlashSale;
use App\Models\FlashSaleProduct;
use Illuminate\Http\Request;

class FlashSaleController extends Controller
{
    public function active()
    {
        $flashSale = FlashSale::active()
            ->with(['products' => function ($query) {
            // Eager load product data and pivot columns
            $query->select('products.id', 'products.name', 'products.slug', 'products.price', 'products.image');
        }])
            ->first();

        if (!$flashSale) {
            return response()->json(['active' => false, 'message' => 'No active flash sale found.']);
        }

        // Transform the products to include pivot data directly
        $products = $flashSale->products->map(function ($product) {
            return [
            'id' => $product->id,
            'name' => $product->name,
            'slug' => $product->slug,
            'image' => $product->image ? url('storage/' . $product->image) : null,
            'price' => $product->price,
            'sale_price' => $product->pivot->sale_price,
            'discount_percentage' => round((($product->price - $product->pivot->sale_price) / $product->price) * 100),
            'sold' => $product->pivot->sold_count ?? 0,
            'stock' => $product->pivot->stock_limit ?? 0,
            ];
        });

        return response()->json([
            'active' => true,
            'id' => $flashSale->id,
            'title' => $flashSale->title,
            'ends_at' => $flashSale->ends_at,
            'products' => $products,
        ]);
    }
}
