<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order; // Assuming Order model exists, need to verify
use Illuminate\Support\Facades\Auth;

class OrderController extends Controller
{
    public function index(Request $request)
    {
        $user = $request->user();
        if (!$user) {
            return response()->json(['message' => 'Unauthorized'], 401);
        }

        $orders = Order::where('user_id', $user->id)
            ->with(['items.product']) // Load eager relationships
            ->latest()
            ->paginate(10);

        return response()->json($orders);
    }

    public function show($id, Request $request)
    {
        $user = $request->user();
        $order = Order::where('user_id', $user->id)
            ->where('id', $id)
            ->with(['items.product'])
            ->first();

        if (!$order) {
            return response()->json(['message' => 'Order not found'], 404);
        }

        return response()->json($order);
    }
}
