<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SiteSettingsController extends Controller
{
    public function index()
    {
        // Fetch all settings as key-value pairs
        $settings = Setting::all()->pluck('value', 'key');

        // Return structured data for frontend
        return response()->json([
            'site_name' => $settings['site_name'] ?? 'Twelve Clothing',
            'contact_email' => $settings['contact_email'] ?? 'support@twelve.com',
            'contact_phone' => $settings['contact_phone'] ?? '+1 (555) 123-4567',
            'social' => [
                'facebook' => $settings['facebook_url'] ?? '#',
                'twitter' => $settings['twitter_url'] ?? '#',
                'instagram' => $settings['instagram_url'] ?? '#',
                'youtube' => $settings['youtube_url'] ?? '#',
            ],
            'logo' => $settings['logo'] ?? null,
            'announcement' => [
                'is_visible' => (bool)($settings['announcement_is_visible'] ?? true),
                'text' => $settings['announcement_text'] ?? 'Free shipping on orders over $100 — Use code TWELVE26 for 15% off',
                'bg_color' => $settings['announcement_bg_color'] ?? '#0f172a',
                'text_color' => $settings['announcement_text_color'] ?? '#ffffff',
                'link' => $settings['announcement_link'] ?? '/products',
            ],
            'countdown' => [
                'is_visible' => (bool)($settings['countdown_is_visible'] ?? false),
                'title' => $settings['countdown_title'] ?? 'Season Ending Sale!',
                'end_time' => $settings['countdown_end_time'] ?? null,
                'bg_color' => $settings['countdown_bg_color'] ?? '#dc2626',
                'text_color' => $settings['countdown_text_color'] ?? '#ffffff',
            ],
        ]);
    }
}
