<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Banner;

class HomeController extends Controller
{
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        // In a Vue SPA, we typically just return the view that mounts the app.
        // However, we can pass initial data props if we want to avoid an immediate API call,
        // though typically we let Vue fetch its own data.
        return view('welcome');
    }

    /**
     * API endpoint for Home page data aggregation (Optional but efficient)
     */
    public function apiData()
    {
        return response()->json([
            'banners' => Banner::where('is_active', true)->latest()->get(),
            'categories' => \App\Models\Category::where('is_active', true)
            ->whereNull('parent_id') // Top level categories
            ->withCount('products')
            ->take(6)
            ->get(),
            'featured_products' => Product::where('is_active', true)->where('is_featured', true)->take(8)->get(),
            'new_arrivals' => Product::where('is_active', true)->latest()->take(8)->get(),
        ]);
    }
}
