<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Purchase extends Model
{
    use HasFactory;

    protected $fillable = ['vendor_id', 'total_amount', 'status', 'purchase_date', 'notes'];

    protected $casts = ['total_amount' => 'decimal:2', 'purchase_date' => 'date'];

    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }
}
