<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TaxRate extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'rate', 'country', 'state', 'type', 'is_active', 'priority'];

    protected $casts = [
        'rate' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    public function scopeActive($query)
    {
        return $query->where('is_active', true)->orderBy('priority');
    }

    public function calculateTax(float $amount): float
    {
        return match ($this->type) {
                'percentage' => round($amount * ($this->rate / 100), 2),
                'fixed' => $this->rate,
                default => 0,
            };
    }
}
