<?php

namespace App\Observers;

use App\Models\Order;
use App\Models\Product;

class OrderObserver
{
    /**
     * Handle the Order "created" event.
     */
    public function created(Order $order)
    {
        // Update product stock when order is created
        foreach ($order->items as $item) {
            $product = Product::find($item->product_id);
            if ($product) {
                $product->decreaseStock($item->quantity);
            }
        }
    }

    /**
     * Handle the Order "updated" event.
     */
    public function updated(Order $order)
    {
        // If order status changed to "cancelled", restore stock
        if ($order->wasChanged('status') && $order->status === 'cancelled') {
            foreach ($order->items as $item) {
                $product = Product::find($item->product_id);
                if ($product) {
                    $product->increaseStock($item->quantity);
                }
            }
        }
    }
}
