<?php

namespace App\Observers;

use App\Models\Order;
use App\Models\StockMovement;
use App\Models\Product;
use App\Models\ProductVariation;

class StockMovementObserver
{
    /**
     * Handle the Product "updated" event.
     * Note: This is a basic implementation. Ideally, we should track 
     * exactly how much stock changed and why.
     */
    public function updated(Product $product)
    {
        if ($product->wasChanged('stock')) {
            $original = $product->getOriginal('stock');
            $current = $product->stock;
            $diff = $current - $original;

            if ($diff != 0) {
                StockMovement::create([
                    'product_id' => $product->id,
                    'type' => $diff > 0 ? 'in' : 'out',
                    'quantity' => abs($diff),
                    'reason' => 'Manual adjustment or bulk update'
                ]);
            }
        }
    }
}
