<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
    //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        \App\Models\Order::observe(\App\Observers\OrderObserver::class);
        \App\Models\Product::observe(\App\Observers\StockMovementObserver::class);

        \Filament\Facades\Filament::registerNavigationGroups([
            'Shop Management',
            'Sales & CRM',
            'Content Management',
            'Marketing',
            'Inventory & Logistics',
            'Admin & Settings',
        ]);

        \Filament\Facades\Filament::registerStyles([
            asset('css/filament-custom.css'),
        ]);
    }
}
