<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Filament\Facades\Filament;
use Filament\Navigation\UserMenuItem;

class FilamentServiceProvider extends ServiceProvider
{
    public function boot()
    {
        Filament::serving(function () {
            Filament::registerNavigationGroups([
                'Shop Management',
                'Order Management',
                'Inventory',
                'Content Management',
                'Finance',
                'Marketplace',
            ]);

            Filament::registerRenderHook(
                'user-menu.start',
            fn() => view('filament.header-button'),
            );
        });
    }
}
