<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAdvancedFieldsToProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->string('sku', 100)->nullable()->unique()->after('id');
            $table->text('short_description')->nullable()->after('description');
            $table->integer('low_stock_warning')->default(10)->after('stock');
            $table->datetime('sale_price_start')->nullable()->after('sale_price');
            $table->datetime('sale_price_end')->nullable()->after('sale_price_start');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('products', function (Blueprint $table) {
        //
        });
    }
}
