<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class EnhanceProductVariationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('product_variations', function (Blueprint $table) {
            $table->string('sku', 100)->nullable()->unique()->after('id');
            $table->integer('stock')->default(0)->after('price_adjustment');
            $table->boolean('is_active')->default(true)->after('stock');
        // $table->dropColumn('stock_adjustment'); // SQLite limitation workaround
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('product_variations', function (Blueprint $table) {
        //
        });
    }
}
