<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCategoryTypeToCategories extends Migration
{
    public function up()
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->string('type')->nullable()->after('name'); // men, women, kids, eid, etc.
            $table->string('parent_slug')->nullable()->after('type'); // for subcategories
        });
    }

    public function down()
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->dropColumn(['type', 'parent_slug']);
        });
    }
}
