<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMissingColumnsToProductsTable extends Migration
{
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            if (!Schema::hasColumn('products', 'brand_id')) {
                $table->foreignId('brand_id')->nullable()->after('category_id')->constrained()->nullOnDelete();
            }
            if (!Schema::hasColumn('products', 'short_description')) {
                $table->string('short_description', 500)->nullable()->after('description');
            }
            if (!Schema::hasColumn('products', 'sku')) {
                $table->string('sku', 50)->nullable()->unique()->after('sale_price');
            }
            if (!Schema::hasColumn('products', 'stock')) {
                $table->integer('stock')->default(0)->after('sku');
            }
            if (!Schema::hasColumn('products', 'low_stock_warning')) {
                $table->integer('low_stock_warning')->default(10)->after('stock');
            }
            if (!Schema::hasColumn('products', 'sale_price_start')) {
                $table->timestamp('sale_price_start')->nullable()->after('sale_price');
            }
            if (!Schema::hasColumn('products', 'sale_price_end')) {
                $table->timestamp('sale_price_end')->nullable()->after('sale_price_start');
            }
        });
    }

    public function down()
    {
        Schema::table('products', function (Blueprint $table) {
            $columns = ['brand_id', 'short_description', 'sku', 'stock', 'low_stock_warning', 'sale_price_start', 'sale_price_end'];
            foreach ($columns as $col) {
                if (Schema::hasColumn('products', $col)) {
                    $table->dropColumn($col);
                }
            }
        });
    }
}
