<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDetailsToVendorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('vendors', function (Blueprint $table) {
            if (!Schema::hasColumn('vendors', 'store_name')) {
                $table->string('store_name')->nullable();
            }
            if (!Schema::hasColumn('vendors', 'description')) {
                $table->text('description')->nullable();
            }
            if (!Schema::hasColumn('vendors', 'logo')) {
                $table->string('logo')->nullable();
            }
            if (!Schema::hasColumn('vendors', 'is_active')) {
                $table->boolean('is_active')->default(true);
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('vendors', function (Blueprint $table) {
        //
        });
    }
}
