<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;
use App\Models\Product;

class CategoryUpdateSeeder extends Seeder
{
    public function run()
    {
        // Update existing categories with types
        $updates = [
            'electronics' => 'men',
            'fashion' => null, // General
            'home' => null,
            'accessories' => null,
            'outdoor' => 'men',
            'gaming' => null,
            'books' => null,
            'art' => null,
        ];

        foreach ($updates as $slug => $type) {
            Category::where('slug', $slug)->update(['type' => $type]);
        }

        // Create new categories for Men, Women, Kids, EID
        $newCategories = [
            // EID Collection
            [
                'name' => 'EID Collection 2026',
                'slug' => 'eid-2026',
                'type' => 'eid',
                'image' => 'https://images.unsplash.com/photo-1583009594853-21fd0ba33ca0',
            ],
            // Valentine
            [
                'name' => 'Valentine 2026',
                'slug' => 'valentine-2026',
                'type' => 'valentine',
                'image' => 'https://images.unsplash.com/photo-1518199266791-5375a83190b7',
            ],
            // Men's Categories
            [
                'name' => 'Men',
                'slug' => 'men',
                'type' => 'men',
                'image' => 'https://images.unsplash.com/photo-1490578474895-699cd4e2cf59',
            ],
            [
                'name' => 'Men\'s Clothing',
                'slug' => 'men-clothing',
                'type' => 'men',
                'parent_slug' => 'men',
                'image' => 'https://images.unsplash.com/photo-1516257984-b1b4d707412e',
            ],
            [
                'name' => 'Men\'s Shoes',
                'slug' => 'men-shoes',
                'type' => 'men',
                'parent_slug' => 'men',
                'image' => 'https://images.unsplash.com/photo-1549298916-b41d501d3772',
            ],
            // Women's Categories
            [
                'name' => 'Women',
                'slug' => 'women',
                'type' => 'women',
                'image' => 'https://images.unsplash.com/photo-1483985988355-763728e1935b',
            ],
            [
                'name' => 'Women\'s Clothing',
                'slug' => 'women-clothing',
                'type' => 'women',
                'parent_slug' => 'women',
                'image' => 'https://images.unsplash.com/photo-1490481651871-ab68de25d43d',
            ],
            [
                'name' => 'Women\'s Shoes',
                'slug' => 'women-shoes',
                'type' => 'women',
                'parent_slug' => 'women',
                'image' => 'https://images.unsplash.com/photo-1543163521-1bf539c55dd2',
            ],
            // Kids
            [
                'name' => 'Kids',
                'slug' => 'kids',
                'type' => 'kids',
                'image' => 'https://images.unsplash.com/photo-1519457431-44ccd64a579b',
            ],
            // Sale / Clearance
            [
                'name' => 'Clearance',
                'slug' => 'clearance',
                'type' => 'sale',
                'image' => 'https://images.unsplash.com/photo-1607083206968-13611e3d76db',
            ],
        ];

        foreach ($newCategories as $category) {
            Category::updateOrCreate(
            ['slug' => $category['slug']],
                $category
            );
        }

        echo "Categories updated successfully!\n";
    }
}
