<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    public function run()
    {
        file_put_contents('seeder_log.txt', "Starting seeding...\n");
        try {
            // Create categories
            \DB::table('categories')->insert([
                ['name' => 'EID/26', 'slug' => 'eid-26', 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'Eid Family Combo', 'slug' => 'eid-family-combo', 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'একুশ সংগ্রহ', 'slug' => 'ekush-collection', 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'Men', 'slug' => 'men', 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'Women', 'slug' => 'women', 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'Kids', 'slug' => 'kids', 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'Accessories', 'slug' => 'accessories', 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'Clothing', 'slug' => 'clothing', 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'Books', 'slug' => 'books', 'created_at' => now(), 'updated_at' => now()],
            ]);

            file_put_contents('seeder_log.txt', "Categories seeded.\n", FILE_APPEND);
            $this->command->info('Categories seeded.');

            // Create brands
            \DB::table('brands')->insert([
                ['name' => 'TechPro', 'slug' => 'techpro', 'is_active' => 1, 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'StyleMax', 'slug' => 'stylemax', 'is_active' => 1, 'created_at' => now(), 'updated_at' => now()],
            ]);

            $this->command->info('Brands seeded.');

            // Create products
            \DB::table('products')->insert([
                ['name' => 'Wireless Headphones', 'slug' => 'wireless-headphones', 'category_id' => 1, 'brand_id' => 1, 'price' => 89.99, 'stock' => 45, 'is_featured' => 1, 'is_active' => 1, 'description' => 'Premium wireless headphones', 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'Smart Watch', 'slug' => 'smart-watch', 'category_id' => 1, 'brand_id' => 1, 'price' => 199.99, 'stock' => 5, 'is_featured' => 1, 'is_active' => 1, 'description' => 'Latest smart watch technology', 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'T-Shirt', 'slug' => 't-shirt', 'category_id' => 2, 'brand_id' => 2, 'price' => 24.99, 'stock' => 200, 'is_featured' => 0, 'is_active' => 1, 'description' => 'Cotton t-shirt', 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'Novel Book', 'slug' => 'novel', 'category_id' => 3, 'brand_id' => null, 'price' => 15.99, 'stock' => 3, 'is_featured' => 0, 'is_active' => 1, 'description' => 'Bestselling novel', 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'Laptop Stand', 'slug' => 'laptop-stand', 'category_id' => 1, 'brand_id' => null, 'price' => 39.99, 'stock' => 8, 'is_featured' => 0, 'is_active' => 1, 'description' => 'Ergonomic laptop stand', 'created_at' => now(), 'updated_at' => now()],
            ]);

            $this->command->info('Products seeded.');

            // Create customers
            \DB::table('users')->insert([
                ['name' => 'John Doe', 'email' => 'john@example.com', 'password' => bcrypt('password'), 'created_at' => now(), 'updated_at' => now()],
                ['name' => 'Jane Smith', 'email' => 'jane@example.com', 'password' => bcrypt('password'), 'created_at' => now(), 'updated_at' => now()],
            ]);

            $this->command->info('Users seeded.');

            // Create orders (last 7 days)
            for ($i = 0; $i < 15; $i++) {
                \DB::table('orders')->insert([
                    'user_id' => rand(1, 2), // John or Jane
                    'number' => 'ORD-' . strtoupper(substr(md5(time() . $i), 0, 8)),
                    'total_price' => rand(50, 300),
                    'status' => ['pending', 'processing', 'completed'][rand(0, 2)],
                    'payment_status' => 'paid',
                    'customer_first_name' => 'John',
                    'customer_last_name' => 'Doe',
                    'customer_email' => 'john@example.com',
                    'customer_phone' => '1234567890',
                    'address' => '123 Test St',
                    'city' => 'Test City',
                    'payment_method' => 'cod',
                    'created_at' => now()->subDays(rand(0, 7)),
                    'updated_at' => now()->subDays(rand(0, 7)),
                ]);
            }

            file_put_contents('seeder_log.txt', "Orders seeded. DONE.\n", FILE_APPEND);
            $this->command->info('✅ Sample data created: 3 categories, 2 brands, 5 products, 2 customers, 15 orders');

        }
        catch (\Exception $e) {
            file_put_contents('seeder_log.txt', "ERROR: " . $e->getMessage() . "\n", FILE_APPEND);
            $this->command->error("Seeder failed: " . $e->getMessage());
        }
    }
}
