<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;

class MenSubcategorySeeder extends Seeder
{
    public function run()
    {
        $menId = Category::where('slug', 'men')->value('id');

        if (!$menId) {
            $this->command->error('Men category not found!');
            return;
        }

        // Top Wear
        $topWear = Category::create([
            'name' => 'Top Wear', 'slug' => 'top-wear',
            'parent_id' => $menId, 'is_active' => true,
        ]);
        foreach ([
        'Panjabi' => 'panjabi',
        'Casual Shirt' => 'casual-shirt',
        'Formal Shirt' => 'formal-shirt',
        'T-shirt' => 't-shirt',
        'Polo Shirt' => 'polo-shirt',
        ] as $name => $slug) {
            Category::create([
                'name' => $name, 'slug' => $slug,
                'parent_id' => $topWear->id, 'is_active' => true,
            ]);
        }

        // Bottom Wear
        $bottomWear = Category::create([
            'name' => 'Bottom Wear', 'slug' => 'bottom-wear',
            'parent_id' => $menId, 'is_active' => true,
        ]);
        foreach ([
        'Jeans' => 'jeans',
        'Chino Pants' => 'chino-pants',
        'Formal Pants' => 'formal-pants',
        'Joggers' => 'joggers',
        ] as $name => $slug) {
            Category::create([
                'name' => $name, 'slug' => $slug,
                'parent_id' => $bottomWear->id, 'is_active' => true,
            ]);
        }

        // Activewear
        $activewear = Category::create([
            'name' => 'Activewear', 'slug' => 'activewear',
            'parent_id' => $menId, 'is_active' => true,
        ]);
        foreach ([
        'Gym Jersey' => 'gym-jersey',
        'Tracksuits' => 'tracksuits',
        ] as $name => $slug) {
            Category::create([
                'name' => $name, 'slug' => $slug,
                'parent_id' => $activewear->id, 'is_active' => true,
            ]);
        }

        // Outerwear
        $outerwear = Category::create([
            'name' => 'Outerwear', 'slug' => 'outerwear',
            'parent_id' => $menId, 'is_active' => true,
        ]);
        foreach ([
        'Jackets' => 'jackets',
        'Hoodies' => 'hoodies',
        ] as $name => $slug) {
            Category::create([
                'name' => $name, 'slug' => $slug,
                'parent_id' => $outerwear->id, 'is_active' => true,
            ]);
        }

        $this->command->info('✅ Men subcategories created: Top Wear, Bottom Wear, Activewear, Outerwear with all items.');
    }
}
