<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Order;
use App\Models\OrderItem;
use App\Models\User;
use App\Models\Product;

class OrderSeeder extends Seeder
{
    public function run()
    {
        // Get or create a test user
        $user = User::firstOrCreate(
        ['email' => 'customer@example.com'],
        [
            'name' => 'Test Customer',
            'password' => bcrypt('password')
        ]
        );

        // Get some products
        $products = Product::take(5)->get();

        if ($products->isEmpty()) {
            echo "No products found. Please create products first.\n";
            return;
        }

        // Create 15 sample orders over the last 30 days
        $statuses = ['pending', 'processing', 'completed', 'completed', 'completed']; // More completed orders

        for ($i = 0; $i < 15; $i++) {
            $daysAgo = rand(0, 30);
            $createdAt = now()->subDays($daysAgo);

            $orderNumber = 'ORD-' . strtoupper(substr(md5(uniqid()), 0, 8));

            // Calculate random total
            $itemCount = rand(1, 3);
            $totalPrice = 0;

            $order = Order::create([
                'user_id' => $user->id,
                'number' => $orderNumber,
                'total_price' => 0, // Will update after items
                'status' => $statuses[array_rand($statuses)],
                'created_at' => $createdAt,
                'updated_at' => $createdAt,
            ]);

            // Add order items
            for ($j = 0; $j < $itemCount; $j++) {
                $product = $products->random();
                $quantity = rand(1, 3);
                $price = $product->price;
                $totalPrice += ($price * $quantity);

                OrderItem::create([
                    'order_id' => $order->id,
                    'product_id' => $product->id,
                    'quantity' => $quantity,
                    'unit_price' => $price,
                ]);
            }

            // Update order total
            $order->update(['total_price' => $totalPrice]);
        }

        echo "Created 15 sample orders successfully!\n";
    }
}
