<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;
use App\Models\Product;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Clear existing (optional, but good for idempotent seeding in dev)
        // Product::truncate(); 
        // Category::truncate();

        // 1. Ensure Categories Exist
        $electronics = Category::firstOrCreate(['slug' => 'electronics'], ['name' => 'Electronics', 'image' => 'https://images.unsplash.com/photo-1498049381145-2564537d2656']);
        $fashion = Category::firstOrCreate(['slug' => 'fashion'], ['name' => 'Fashion', 'image' => 'https://images.unsplash.com/photo-1445205170230-053b83016050']);
        $home = Category::firstOrCreate(['slug' => 'home'], ['name' => 'Home', 'image' => 'https://images.unsplash.com/photo-1586023492125-27b2c045efd7']);
        $accessories = Category::firstOrCreate(['slug' => 'accessories'], ['name' => 'Accessories', 'image' => 'https://images.unsplash.com/photo-1511556532299-8f662fc26c06']);
        $outdoor = Category::firstOrCreate(['slug' => 'outdoor'], ['name' => 'Outdoor', 'image' => 'https://images.unsplash.com/photo-1504280509243-4891d6006f2d']);
        $gaming = Category::firstOrCreate(['slug' => 'gaming'], ['name' => 'Gaming', 'image' => 'https://images.unsplash.com/photo-1552820728-8b83bb6b773f']);
        $books = Category::firstOrCreate(['slug' => 'books'], ['name' => 'Books', 'image' => 'https://images.unsplash.com/photo-1495446815901-a7297e633e8d']);
        $art = Category::firstOrCreate(['slug' => 'art'], ['name' => 'Art', 'image' => 'https://images.unsplash.com/photo-1513364776144-60967b0f800f']);

        // 2. Add Products
        $products = [
            // Tech / Electronics
            [
                'category_id' => $electronics->id,
                'name' => 'Quantam Heads-Up Display',
                'slug' => 'quantum-hud',
                'price' => 299.99,
                'image' => 'https://images.unsplash.com/photo-1531297461136-82lw9z1.jpg', // Abstract tech
                'is_featured' => true,
                'is_active' => true,
            ],
            [
                'category_id' => $electronics->id,
                'name' => 'Sonic Levitation Speaker',
                'slug' => 'sonic-levitation-speaker',
                'price' => 149.50,
                'image' => 'https://images.unsplash.com/photo-1608231387042-66d1773070a5',
                'is_active' => true,
            ],

            // Gaming
            [
                'category_id' => $gaming->id,
                'name' => 'VR Treadmill',
                'slug' => 'vr-treadmill',
                'price' => 1299.00,
                'image' => 'https://images.unsplash.com/photo-1592478411213-61535fdd861d',
                'is_active' => true,
            ],
            [
                'category_id' => $gaming->id,
                'name' => 'Haptic Suit',
                'slug' => 'haptic-suit',
                'price' => 499.00,
                'is_featured' => true,
                'image' => 'https://images.unsplash.com/photo-1550745165-9bc0b252726f',
                'is_active' => true,
            ],

            // Books
            [
                'category_id' => $books->id,
                'name' => 'The Physics of Anti-Gravity',
                'slug' => 'physics-anti-gravity',
                'price' => 24.99,
                'image' => 'https://images.unsplash.com/photo-1589829085413-56de8ae18c73',
                'is_active' => true,
            ],

            // Art
            [
                'category_id' => $art->id,
                'name' => 'Floating Sculpture',
                'slug' => 'floating-sculpture',
                'price' => 450.00,
                'image' => 'https://images.unsplash.com/photo-1579783902614-a3fb3927b6a5',
                'is_active' => true,
            ],

            // Fashion
            [
                'category_id' => $fashion->id,
                'name' => 'Anti-Gravity Sneakers',
                'slug' => 'anti-gravity-sneakers',
                'price' => 189.00,
                'image' => 'https://images.unsplash.com/photo-1542291026-7eec264c27ff',
                'is_featured' => true,
                'is_active' => true,
            ],
            [
                'category_id' => $fashion->id,
                'name' => 'Aerotek Jacket',
                'slug' => 'aerotek-jacket',
                'price' => 249.00,
                'image' => 'https://images.unsplash.com/photo-1591047139829-d91aecb6caea',
                'is_active' => true,
            ],
            [
                'category_id' => $fashion->id,
                'name' => 'Nebula Scarf',
                'slug' => 'nebula-scarf',
                'price' => 45.00,
                'image' => 'https://images.unsplash.com/photo-1520903920248-614150816a75',
                'is_active' => true,
            ],

            // Home
            [
                'category_id' => $home->id,
                'name' => 'Levitating Lamp',
                'slug' => 'levitating-lamp',
                'price' => 129.00,
                'sale_price' => 99.00,
                'on_sale' => true,
                'image' => 'https://images.unsplash.com/photo-1507473888900-52ea75561061',
                'is_active' => true,
            ],
            [
                'category_id' => $home->id,
                'name' => 'Zero-G Planter',
                'slug' => 'zero-g-planter',
                'price' => 59.99,
                'image' => 'https://images.unsplash.com/photo-1485955900006-10f4d324d411',
                'is_active' => true,
            ],

            // Accessories
            [
                'category_id' => $accessories->id,
                'name' => 'Zero-G Backpack',
                'slug' => 'zero-g-backpack',
                'price' => 89.00,
                'image' => 'https://images.unsplash.com/photo-1553062407-98eeb64c6a62',
                'is_active' => true,
            ],
            [
                'category_id' => $accessories->id,
                'name' => 'Lunar Watch',
                'slug' => 'lunar-watch',
                'price' => 399.00,
                'is_featured' => true,
                'image' => 'https://images.unsplash.com/photo-1524592094714-0f0654e20314',
                'is_active' => true,
            ],
            [
                'category_id' => $accessories->id,
                'name' => 'Titanium Sunglasses',
                'slug' => 'titanium-sunglasses',
                'price' => 150.00,
                'sale_price' => 120.00,
                'on_sale' => true,
                'image' => 'https://images.unsplash.com/photo-1511499767150-a48a237f0083',
                'is_active' => true,
            ],

            // Outdoor
            [
                'category_id' => $outdoor->id,
                'name' => 'Hoverboard Pro',
                'slug' => 'hoverboard-pro',
                'price' => 899.00,
                'is_featured' => true,
                'image' => 'https://images.unsplash.com/photo-1564982752979-3f7bc974d29a', // Skateboard placeholder
                'is_active' => true,
            ],
            [
                'category_id' => $outdoor->id,
                'name' => 'Solar Backpack',
                'slug' => 'solar-backpack',
                'price' => 120.00,
                'image' => 'https://images.unsplash.com/photo-1622560480605-d83c853bc5c3',
                'is_active' => true,
            ],
        ];

        foreach ($products as $product) {
            Product::updateOrCreate(['slug' => $product['slug']], $product);
        }
    }
}
