<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Category;
use App\Models\Brand;
use App\Models\Product;
use App\Models\Order;
use App\Models\OrderItem;
use App\Models\Review;

class SampleDataSeeder extends Seeder
{
    public function run()
    {
        // Create sample customers
        $customers = [];
        for ($i = 1; $i <= 20; $i++) {
            $customers[] = User::create([
                'name' => 'Customer ' . $i,
                'email' => 'customer' . $i . '@example.com',
                'password' => bcrypt('password'),
            ]);
        }

        // Create categories
        $categories = [
            ['name' => 'Electronics', 'slug' => 'electronics', 'description' => 'Electronic devices and gadgets'],
            ['name' => 'Clothing', 'slug' => 'clothing', 'description' => 'Fashion and apparel'],
            ['name' => 'Books', 'slug' => 'books', 'description' => 'Books and magazines'],
            ['name' => 'Home & Garden', 'slug' => 'home-garden', 'description' => 'Home improvement and garden supplies'],
            ['name' => 'Sports', 'slug' => 'sports', 'description' => 'Sports equipment and gear'],
        ];

        foreach ($categories as $cat) {
            Category::create($cat);
        }

        // Create brands
        $brands = [
            ['name' => 'TechPro', 'slug' => 'techpro', 'description' => 'Professional tech solutions', 'is_active' => true],
            ['name' => 'StyleMax', 'slug' => 'stylemax', 'description' => 'Modern fashion brand', 'is_active' => true],
            ['name' => 'HomeComfort', 'slug' => 'homecomfort', 'description' => 'Comfort for your home', 'is_active' => true],
            ['name' => 'FitGear', 'slug' => 'fitgear', 'description' => 'Professional sports equipment', 'is_active' => true],
        ];

        foreach ($brands as $brand) {
            Brand::create($brand);
        }

        // Create products
        $products = [
            ['name' => 'Wireless Headphones', 'category_id' => 1, 'brand_id' => 1, 'price' => 89.99, 'stock' => 45, 'is_featured' => true],
            ['name' => 'Smart Watch', 'category_id' => 1, 'brand_id' => 1, 'price' => 199.99, 'stock' => 5, 'is_featured' => true],
            ['name' => 'Laptop Stand', 'category_id' => 1, 'brand_id' => 1, 'price' => 39.99, 'stock' => 120],
            ['name' => 'Cotton T-Shirt', 'category_id' => 2, 'brand_id' => 2, 'price' => 24.99, 'stock' => 200, 'on_sale' => true, 'sale_price' => 19.99],
            ['name' => 'Jeans', 'category_id' => 2, 'brand_id' => 2, 'price' => 59.99, 'stock' => 8],
            ['name' => 'Programming Book', 'category_id' => 3, 'brand_id' => null, 'price' => 44.99, 'stock' => 50],
            ['name' => 'Novel Collection', 'category_id' => 3, 'brand_id' => null, 'price' => 29.99, 'stock' => 3, 'is_featured' => true],
            ['name' => 'Garden Tools Set', 'category_id' => 4, 'brand_id' => 3, 'price' => 79.99, 'stock' => 25],
            ['name' => 'Indoor Plant Pot', 'category_id' => 4, 'brand_id' => 3, 'price' => 15.99, 'stock' => 6],
            ['name' => 'Yoga Mat', 'category_id' => 5, 'brand_id' => 4, 'price' => 34.99, 'stock' => 75, 'is_featured' => true],
            ['name' => 'Dumbbells Set', 'category_id' => 5, 'brand_id' => 4, 'price' => 129.99, 'stock' => 15],
            ['name' => 'Running Shoes', 'category_id' => 5, 'brand_id' => 4, 'price' => 89.99, 'stock' => 2],
        ];

        foreach ($products as $key => $prod) {
            Product::create([
                'name' => $prod['name'],
                'slug' => \Illuminate\Support\Str::slug($prod['name']),
                'description' => 'High-quality ' . strtolower($prod['name']) . ' for your needs.',
                'category_id' => $prod['category_id'],
                'brand_id' => $prod['brand_id'] ?? null,
                'price' => $prod['price'],
                'sale_price' => $prod['sale_price'] ?? null,
                'stock' => $prod['stock'],
                'is_featured' => $prod['is_featured'] ?? false,
                'is_active' => true,
                'on_sale' => $prod['on_sale'] ?? false,
            ]);
        }

        // Create orders (last 30 days)
        for ($i = 0; $i < 50; $i++) {
            $customer = $customers[array_rand($customers)];
            $order = Order::create([
                'user_id' => $customer->id,
                'number' => 'ORD-' . strtoupper(substr(md5(time() . $i), 0, 8)),
                'total_price' => rand(50, 500),
                'status' => ['pending', 'processing', 'completed', 'declined'][array_rand(['pending', 'processing', 'completed', 'declined'])],
                'payment_status' => ['paid', 'unpaid'][array_rand(['paid', 'unpaid'])],
                'shipping_address' => $customer->name . ', ' . rand(100, 999) . ' Main St, City, State',
                'created_at' => now()->subDays(rand(0, 30)),
            ]);

            // Add 1-3 items per order
            $itemCount = rand(1, 3);
            for ($j = 0; $j < $itemCount; $j++) {
                $product = Product::inRandomOrder()->first();
                OrderItem::create([
                    'order_id' => $order->id,
                    'product_id' => $product->id,
                    'quantity' => rand(1, 3),
                    'unit_price' => $product->price,
                ]);
            }
        }

        // Create reviews
        for ($i = 0; $i < 30; $i++) {
            Review::create([
                'product_id' => Product::inRandomOrder()->first()->id,
                'user_id' => $customers[array_rand($customers)]->id,
                'rating' => rand(3, 5),
                'comment' => 'Great product! Really satisfied with my purchase.',
                'is_approved' => (bool)rand(0, 1),
            ]);
        }

        $this->command->info('Sample data created successfully!');
    }
}
