<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class ShopSeeder extends Seeder
{
    public function run()
    {
        $this->command->info('=== ShopSeeder Start ===');

        $categories = [
            ['name' => 'EID/26 Collection', 'slug' => 'eid-2026', 'type' => null, 'description' => 'Celebrate Eid in style with our exclusive collection.', 'is_active' => true],
            ['name' => "Falgun & Valentine'26", 'slug' => 'valentine-2026', 'type' => null, 'description' => 'Special collection for Falgun & Valentines Day 2026.', 'is_active' => true],
            ['name' => 'Clearance Craze', 'slug' => 'clearance', 'type' => null, 'description' => 'Massive discounts on selected items!', 'is_active' => true],
            ['name' => "Men's Collection", 'slug' => 'men', 'type' => 'men', 'description' => 'Latest mens fashion and essentials.', 'is_active' => true],
            ['name' => "Women's Collection", 'slug' => 'women', 'type' => 'women', 'description' => 'Trendy and elegant clothing.', 'is_active' => true],
            ['name' => 'Kids Collection', 'slug' => 'kids', 'type' => 'kids', 'description' => 'Fun and stylish clothing for little ones.', 'is_active' => true],
            ['name' => 'Accessories', 'slug' => 'accessories', 'type' => 'accessories', 'description' => 'Complete your look.', 'is_active' => true],
            ['name' => 'Sale!!', 'slug' => 'sale', 'type' => null, 'description' => 'Amazing deals and special offers.', 'is_active' => true],
        ];

        $categoryIds = [];
        foreach ($categories as $cat) {
            $existing = DB::table('categories')->where('slug', $cat['slug'])->first();
            if ($existing) {
                $categoryIds[$cat['slug']] = $existing->id;
            } else {
                $id = DB::table('categories')->insertGetId(array_merge($cat, ['created_at' => now(), 'updated_at' => now()]));
                $categoryIds[$cat['slug']] = $id;
            }
        }
        $this->command->info('Categories: ' . count($categoryIds) . ' ready');

        $brands = [
            ['name' => 'Aarong', 'slug' => 'aarong', 'description' => 'Traditional Bangladeshi fashion.'],
            ['name' => 'Yellow', 'slug' => 'yellow', 'description' => 'Contemporary fashion.'],
            ['name' => 'Ecstasy', 'slug' => 'ecstasy', 'description' => 'Premium fashion wear.'],
            ['name' => 'Sailor', 'slug' => 'sailor', 'description' => 'Trendy casual and formal wear.'],
            ['name' => 'Richman', 'slug' => 'richman', 'description' => 'Quality menswear.'],
            ['name' => 'Gentle Park', 'slug' => 'gentle-park', 'description' => 'Elegant fashion.'],
            ['name' => 'Le Reve', 'slug' => 'le-reve', 'description' => 'International fashion trends.'],
            ['name' => 'Infinity', 'slug' => 'infinity', 'description' => 'Bold urban fashion.'],
        ];

        foreach ($brands as $brand) {
            if (!DB::table('brands')->where('slug', $brand['slug'])->exists()) {
                DB::table('brands')->insert(array_merge($brand, ['is_active' => true, 'created_at' => now(), 'updated_at' => now()]));
            }
        }
        $this->command->info('Brands: ' . DB::table('brands')->count() . ' ready');

        $productData = [
            'eid-2026' => [
                ['name' => 'Midnight Blue Panjabi', 'price' => 3500, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Golden Embroidered Sherwani', 'price' => 8500, 'sale_price' => 6999, 'on_sale' => true],
                ['name' => 'Silk Saree - Ruby Red', 'price' => 7500, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Pearl White Salwar Kameez', 'price' => 4200, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Premium Kabli Set - Navy', 'price' => 5000, 'sale_price' => 3999, 'on_sale' => true],
                ['name' => 'Kids Festive Kurta', 'price' => 1800, 'sale_price' => null, 'on_sale' => false],
            ],
            'valentine-2026' => [
                ['name' => 'Red Rose Silk Dress', 'price' => 4500, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Couple Matching T-Shirt Set', 'price' => 2200, 'sale_price' => 1799, 'on_sale' => true],
                ['name' => 'Heart Pendant Necklace', 'price' => 1500, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Falgun Special Saree', 'price' => 6000, 'sale_price' => 4999, 'on_sale' => true],
            ],
            'men' => [
                ['name' => 'Classic Fit Oxford Shirt', 'price' => 2500, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Slim Fit Chino Pants', 'price' => 3200, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Leather Bomber Jacket', 'price' => 12000, 'sale_price' => 9999, 'on_sale' => true],
                ['name' => 'Premium Polo T-Shirt', 'price' => 1800, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Formal Blazer - Charcoal', 'price' => 8500, 'sale_price' => null, 'on_sale' => false],
            ],
            'women' => [
                ['name' => 'Floral Maxi Dress', 'price' => 3800, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Embroidered Kurti - Teal', 'price' => 2800, 'sale_price' => 2199, 'on_sale' => true],
                ['name' => 'Palazzo Pants Set', 'price' => 3500, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Denim Jacket - Vintage', 'price' => 4500, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Chiffon Dupatta Collection', 'price' => 1200, 'sale_price' => 899, 'on_sale' => true],
            ],
            'kids' => [
                ['name' => 'Rainbow Hoodie - Unisex', 'price' => 1500, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Cartoon Print T-Shirt Pack', 'price' => 1200, 'sale_price' => 999, 'on_sale' => true],
                ['name' => 'Kids Denim Shorts', 'price' => 900, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Princess Party Dress', 'price' => 2500, 'sale_price' => null, 'on_sale' => false],
            ],
            'accessories' => [
                ['name' => 'Leather Wallet - Brown', 'price' => 1800, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Aviator Sunglasses', 'price' => 2500, 'sale_price' => 1999, 'on_sale' => true],
                ['name' => 'Canvas Backpack', 'price' => 3200, 'sale_price' => null, 'on_sale' => false],
                ['name' => 'Stainless Steel Watch', 'price' => 5500, 'sale_price' => null, 'on_sale' => false],
            ],
            'clearance' => [
                ['name' => 'Winter Wool Scarf', 'price' => 1500, 'sale_price' => 599, 'on_sale' => true],
                ['name' => 'Cotton Casual Shirt', 'price' => 2200, 'sale_price' => 999, 'on_sale' => true],
                ['name' => 'Sports Joggers', 'price' => 2800, 'sale_price' => 1499, 'on_sale' => true],
                ['name' => 'Printed Tote Bag', 'price' => 800, 'sale_price' => 399, 'on_sale' => true],
            ],
            'sale' => [
                ['name' => 'Oversized Graphic Tee', 'price' => 1500, 'sale_price' => 799, 'on_sale' => true],
                ['name' => 'Linen Summer Pants', 'price' => 3000, 'sale_price' => 1799, 'on_sale' => true],
                ['name' => 'Beaded Bracelet Set', 'price' => 600, 'sale_price' => 299, 'on_sale' => true],
            ],
        ];

        $count = 0;
        foreach ($productData as $catSlug => $products) {
            $catId = $categoryIds[$catSlug] ?? null;
            if (!$catId) continue;
            foreach ($products as $idx => $prod) {
                if (DB::table('products')->where('name', $prod['name'])->where('category_id', $catId)->exists()) continue;
                DB::table('products')->insert([
                    'name' => $prod['name'],
                    'slug' => Str::slug($prod['name']) . '-' . substr(uniqid(), -5),
                    'description' => 'Premium quality product. Limited stock available.',
                    'price' => $prod['price'],
                    'sale_price' => $prod['sale_price'],
                    'on_sale' => $prod['on_sale'],
                    'stock' => rand(10, 50),
                    'category_id' => $catId,
                    'is_active' => true,
                    'is_featured' => $idx < 2,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
                $count++;
            }
        }
        $this->command->info("Products: {$count} created");
        $this->command->info('=== ShopSeeder Complete ===');
    }
}
