<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;

class WomenKidsAccessoriesSubcategorySeeder extends Seeder
{
    public function run()
    {
        // ===== WOMEN =====
        $womenId = Category::where('slug', 'women')->value('id');
        if (!$womenId) {
            $this->command->error('Women category not found!');
            return;
        }

        $ethnicWear = Category::create(['name' => 'Ethnic Wear', 'slug' => 'ethnic-wear', 'parent_id' => $womenId, 'is_active' => true]);
        foreach ([
        'Saree' => 'saree',
        'Three Piece' => 'three-piece',
        'Kurti' => 'kurti',
        'Abaya & Borka' => 'abaya-borka',
        ] as $name => $slug) {
            Category::create(['name' => $name, 'slug' => $slug, 'parent_id' => $ethnicWear->id, 'is_active' => true]);
        }

        $westernWear = Category::create(['name' => 'Western Wear', 'slug' => 'western-wear', 'parent_id' => $womenId, 'is_active' => true]);
        foreach ([
        'Tops & Tunics' => 'tops-tunics',
        'Ladies Jeans' => 'ladies-jeans',
        'Shrugs & Jackets' => 'shrugs-jackets',
        ] as $name => $slug) {
            Category::create(['name' => $name, 'slug' => $slug, 'parent_id' => $westernWear->id, 'is_active' => true]);
        }

        $innerwear = Category::create(['name' => 'Innerwear & Sleepwear', 'slug' => 'innerwear-sleepwear', 'parent_id' => $womenId, 'is_active' => true]);
        foreach ([
        'Lingerie' => 'lingerie',
        'Night Dress' => 'night-dress',
        ] as $name => $slug) {
            Category::create(['name' => $name, 'slug' => $slug, 'parent_id' => $innerwear->id, 'is_active' => true]);
        }

        $modestWear = Category::create(['name' => 'Modest Wear', 'slug' => 'modest-wear', 'parent_id' => $womenId, 'is_active' => true]);
        foreach ([
        'Hijab' => 'hijab',
        'Inner Cap' => 'inner-cap',
        ] as $name => $slug) {
            Category::create(['name' => $name, 'slug' => $slug, 'parent_id' => $modestWear->id, 'is_active' => true]);
        }

        $this->command->info('✅ Women subcategories created.');

        // ===== KIDS =====
        $kidsId = Category::where('slug', 'kids')->value('id');
        if (!$kidsId) {
            $this->command->error('Kids category not found!');
            return;
        }

        $boys = Category::create(['name' => 'Boys', 'slug' => 'boys', 'parent_id' => $kidsId, 'is_active' => true]);
        foreach ([
        'Panjabi' => 'boys-panjabi',
        'T-shirt & Shorts Set' => 'tshirt-shorts-set',
        'Denim' => 'boys-denim',
        ] as $name => $slug) {
            Category::create(['name' => $name, 'slug' => $slug, 'parent_id' => $boys->id, 'is_active' => true]);
        }

        $girls = Category::create(['name' => 'Girls', 'slug' => 'girls', 'parent_id' => $kidsId, 'is_active' => true]);
        foreach ([
        'Frock' => 'frock',
        'Tops & Leggings' => 'tops-leggings',
        'Party Dress' => 'party-dress',
        ] as $name => $slug) {
            Category::create(['name' => $name, 'slug' => $slug, 'parent_id' => $girls->id, 'is_active' => true]);
        }

        $infants = Category::create(['name' => 'Infants', 'slug' => 'infants', 'parent_id' => $kidsId, 'is_active' => true]);
        foreach ([
        'Rompers' => 'rompers',
        'Baby Care Sets' => 'baby-care-sets',
        ] as $name => $slug) {
            Category::create(['name' => $name, 'slug' => $slug, 'parent_id' => $infants->id, 'is_active' => true]);
        }

        $this->command->info('✅ Kids subcategories created.');

        // ===== ACCESSORIES =====
        $accId = Category::where('slug', 'accessories')->value('id');
        if (!$accId) {
            $this->command->error('Accessories category not found!');
            return;
        }

        $footwear = Category::create(['name' => 'Footwear', 'slug' => 'footwear', 'parent_id' => $accId, 'is_active' => true]);
        foreach ([
        'Sneakers' => 'sneakers',
        'Formal Shoes' => 'formal-shoes',
        'Sandals' => 'sandals',
        'Loafers' => 'loafers',
        ] as $name => $slug) {
            Category::create(['name' => $name, 'slug' => $slug, 'parent_id' => $footwear->id, 'is_active' => true]);
        }

        $bags = Category::create(['name' => 'Bags', 'slug' => 'bags', 'parent_id' => $accId, 'is_active' => true]);
        foreach ([
        'Backpack' => 'backpack',
        'Wallet' => 'wallet',
        'Handbags (Women)' => 'handbags-women',
        ] as $name => $slug) {
            Category::create(['name' => $name, 'slug' => $slug, 'parent_id' => $bags->id, 'is_active' => true]);
        }

        $others = Category::create(['name' => 'Others', 'slug' => 'others-accessories', 'parent_id' => $accId, 'is_active' => true]);
        foreach ([
        'Belts' => 'belts',
        'Watches' => 'watches',
        'Sunglasses' => 'sunglasses',
        'Socks' => 'socks',
        ] as $name => $slug) {
            Category::create(['name' => $name, 'slug' => $slug, 'parent_id' => $others->id, 'is_active' => true]);
        }

        $this->command->info('✅ Accessories subcategories created.');
    }
}
